
# Save as Script
# Copyright 2005 by Alexander V. Christensen

"""
Save the database as a script (.py) file.
  If executed, the file resets the database to the saved version.
"""

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050720 - first version, based on a debugging script by Brian Christensen
# 050801 - added support for database aliases
# 050901 - placed generated code in a function; added save prompt; included the current date in the signature
# 060722 - added IgnoreColumns, FirstColumns, and LastColumns

import os

IgnoreColumns = []
  # these columns will be omitted

FirstColumns = ['ID', 'Name', 'Label']
  # these columns will be listed before the rest

LastColumns = ['zzStatus']
  # these columns will be listed after the rest

signature = '# generated by "' + os.path.basename(thisfile) + '" on ' + Data.GetToday()

header = """#!/usr/bin/env python

""" + signature + """

def ResetDatabase():
    if not Data.AskIfUserWantsToSave("resetting database"):
        return

    Database = {}

    def FillTable(name, columns, data):
        table = {}
        for row in data:
            record = {}
            for i, value in enumerate(row):
                if value or value == 0:
                    col = columns[i]
                    record[col] = value
                id = record['ID']
                table[id] = record
        Database[name] = table
"""

footer = """    Data.CloseReports()
    Data.Database = Database
    Data.MakeReady()

ResetDatabase()"""


def SaveData(path=None):
    output = open(path, 'w')
    print >> output, header

    tables = Data.Database.items()
    tables.sort()
    for tid, t in tables:
        alias = None
        for _tid, _t in tables:
            if _tid >= tid:
                break
            if _t is t:
                alias = _tid
                break
        if alias:
            print >> output, '    Database[' + repr(tid) + '] = Database[' + repr(alias) + ']\n'
            continue

        records = t.items()
        records.sort()

        cmap = {}
        try:
            for rid, r in records:
                for cid in r:
                    if cid not in cmap:
                        cmap[cid] = None
            cmap['ID']
        except:
            print >> output, '    Database[' + repr(tid) + '] =', repr(t), '\n'
            continue

        for cid in IgnoreColumns:
            if cid in cmap:
                del cmap[cid]
        first = []
        for cid in FirstColumns:
            if cid in cmap:
                del cmap[cid]
                first.append(cid)
        last = []
        for cid in LastColumns:
            if cid in cmap:
                del cmap[cid]
                last.append(cid)
        others = cmap.keys()
        others.sort()
        columns = first + others + last

        print >> output, '    name =' , repr(tid)
        print >> output, '    columns =' , repr(columns)
        print >> output, '    data = ['
        for rid, r in records:
            values = []
            for cid in columns:
                v = r.get(cid)
                values.append(v)
            print >> output, '        ' + repr(values) + ','
        print >> output, '        ]'
        print >> output, '    FillTable(name, columns, data)\n'
    print >> output, footer


if Data.FileName:
    name = os.path.basename(Data.FileName)
else:
    name = 'Untitled.py'

path = wx.FileSelector('Save database', '', name, '', 'Python script (*.py)|*.py', wx.SAVE | wx.OVERWRITE_PROMPT)
if path:
    SaveData(path)
